/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.locate;

import dev.toma.gunsrpg.util.locate.IContextIterator;
import dev.toma.gunsrpg.util.locate.ILocator;
import dev.toma.gunsrpg.util.locate.ILocatorPredicate;
import java.util.ArrayList;
import java.util.stream.Stream;

public abstract class AbstractLocator<T, CTX>
implements ILocator<T, CTX> {
    private final T fallbackValue;

    public AbstractLocator(T fallbackValue) {
        this.fallbackValue = fallbackValue;
    }

    @Override
    public T locateFirst(CTX context, IContextIterator<T> iterator, ILocatorPredicate<T> predicate) {
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.isValidResult(t)) continue;
            return t;
        }
        return this.fallbackValue;
    }

    @Override
    public Stream<T> locateAll(CTX context, IContextIterator<T> iterator, ILocatorPredicate<T> predicate) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.isValidResult(t)) continue;
            list.add(t);
        }
        return list.stream();
    }
}

